#define __INFO_AQUI_C__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "info_aqui.h"
#include "namespace.h"
#include "routine.h"
#include "global.h"
#include "evolve.h"
#include "statistics.h"
#include "repertoire.h"
#include "field.h"
#include "utils.h"

NAMESPACE info_aqui;

void init_info_aqui(void)
{
init_namespace(&info_aqui);
}



STAT_FIELD *stat=NULL;
long stat_free=0;
long stat_size=0;
char *filename=NULL;
FILE *stats_out=NULL;


void init_stat(void)
{
stat_size=20;
stat_free=0;
stat=do_alloc(stat_size,sizeof(STAT_FIELD));
}

void reset_stat(void)
{
long i;
for(i=stat_free-1;i>=0;i--)
	delete_stat(i);
}

void delete_stat(long i)
{
long k;
stat_free--;
free(stat[i].name);
free(stat[i].comment);
free(stat[i].condition);
free(stat[i].routine_name);
if(stat[i].data1!=NULL)free(stat[i].data1);
for(k=i;k<stat_free;k++)memcpy(&(stat[k]),&(stat[k+1]),sizeof(STAT_FIELD));
}

void expand_stat(void)
{
long i;
STAT_FIELD *r;

r=do_alloc(stat_size*2,sizeof(STAT_FIELD));
for(i=0;i<stat_free;i++)memcpy(&r[i],&stat[i],sizeof(STAT_FIELD));
free(stat);
stat=r;
stat_size=stat_size*2;
}

STAT_FIELD * add_new_stat(char *name)
{
STAT_FIELD *r;
if(stat_free+1>=stat_size)expand_stat();
r=&(stat[stat_free]);
stat_free++;
r->name=strdup(name);
r->comment=strdup("");
r->type=TYPE_SUM;
r->condition=strdup("false");
r->routine_name=strdup("false");
r->data1=NULL;
r->max_size=2;
r->condition_index=-1;
r->routine_index=-1;
return r;
}


long get_stat_index(char *name)
{
long i;
for(i=0;i<stat_free;i++){
	if(!strcmp(stat[i].name,name))return i;
	}
return -1;
}

STAT_FIELD *get_stat(long index)
{
if(index<0)return NULL;
if(index>=stat_free)return NULL;
return &(stat[index]);
}

char *get_stat_name(long index)
{
STAT_FIELD *r;

r=get_stat(index);
if(r==NULL)return "stat_unknown";
return r->name;
}

void dump_stat(FILE *fout,STAT_FIELD *r)
{
if(r==NULL)return;
switch(r->type){
	case TYPE_BIAS:
		fprintf(fout,"\tbias\t\t\"%s\" \"%s\"\n",
			r->name,r->routine_name);
		break;
	case TYPE_SUM:
		fprintf(fout,"\tsum\t\t\"%s\" \"%s\" \"%s\"\n",
			r->name,r->condition,r->routine_name);
		break;
	case TYPE_DISTRIBUTION:
		fprintf(fout,"\tdistribution\t\"%s\" %ld \"%s\" \"%s\"\n",
			r->name,r->max_size,r->condition,r->routine_name);
		break;
	default:
		fprintf(fout,"\tabstract\n");
		break;
	}
}

void dump_stats(FILE *fout)
{
long i;
fprintf(fout,"statistics\n");
if(filename!=NULL)fprintf(fout,"\tfile\t\t\"%s\"\n",filename);
for(i=0;i<stat_free;i++)
		dump_stat(fout,&(stat[i]));
fprintf(fout,"end\n");
}


long num_stat(void)
{
return stat_free;
}

void set_filename(char *fn)
{
if(stats_out!=NULL){
	fclose(stats_out);
	stats_out=NULL;
	}
if(filename!=NULL){
	free(filename);
	filename=NULL;
	}
if(fn!=NULL)filename=strdup(fn);
}		

void compute_statistics(FIELD *f)
{
long i,j,k;
u64 result,a;
set_current_field(f);
/* initialization */
for(i=0;i<stat_free;i++){
	switch(stat[i].type){
		case TYPE_SUM:
			stat[i].total=0;
			stat[i].value=0;
			break;
		case TYPE_DISTRIBUTION:
			stat[i].total=0;
			for(j=0;j<stat[i].max_size;j++)stat[i].data1[j]=0;
			break;
		case TYPE_BIAS:
			/* nothing */
			break;
		default:
			stat[i].total=0;
			stat[i].value=0;
			break;
		}
	}	
/* here we go */
for(i=0;i<f->x_size;i++)
	for(j=0;j<f->y_size;j++){
		set_current_agent(i,j);
		for(k=0;k<stat_free;k++){
			switch(stat[k].type){
				case TYPE_SUM:
					if(evaluate_routine(stat[k].condition_index,&result)<0)break;
					if(!result)break;
					if(evaluate_routine(stat[k].routine_index,&result)<0)break;
					stat[k].total++;
					stat[k].value+=result;
					break;
				case TYPE_DISTRIBUTION:
					if(evaluate_routine(stat[k].condition_index,&result)<0)break;
					if(!result)break;
					if(evaluate_routine(stat[k].routine_index,&result)<0)break;
					a=result % stat[k].max_size;
					if(a<0)break;
					stat[k].total++;
					stat[k].data1[a]++;
					break;
				case TYPE_BIAS:  /* nothing */
					break;
				default:
					break;
				}
			}
		}
}

long get_number_of_values(long index)
{
if(index<0)return -1;
if(index>=stat_free)return -1;
switch(stat[index].type){
	case TYPE_SUM:
		return 2;
	case TYPE_BIAS:
		return get_repertoire_size(stat[index].routine_index);
	case TYPE_DISTRIBUTION:
		return stat[index].max_size+1;
	default:
		return 0;
	}
}

char s11[200];

char * get_value(long index,long i)
{
ATTRIBUTE *a;
sprintf(s11,"NaN");
if(index<0)return s11;
if(index>=stat_free)return s11;
if(i<0)return s11;
switch(stat[index].type){
	case TYPE_SUM:
		if(i>=2)return s11;
		if(i)sprintf(s11,"%lld",stat[index].value);
			else sprintf(s11,"%lld",stat[index].total);
		return s11;
	case TYPE_BIAS:
		if(i>=get_repertoire_size(stat[index].routine_index))return s11;
		a=get_attribute(stat[index].routine_index);
		if(a==NULL)return s11;
		if(a->type!=TYPE_REPERTOIRE)return s11;
		sprintf(s11,"%d",a->param.rep.bias_values[i]);
		return s11;
	case TYPE_DISTRIBUTION:
		if(i>stat[index].max_size)return s11;
		if(!i){
			sprintf(s11,"%lld",stat[index].total);
			return s11;
		      }
		sprintf(s11,"%lld",stat[index].data1[i-1]);
		return s11;
	default:
		sprintf(s11,"???");
		return s11;
		
	}

}

char * get_value_name(long index,long i)
{
ATTRIBUTE *a;
sprintf(s11,"x");
if(index<0)return s11;
if(index>=stat_free)return s11;
if(i<0)return s11;
switch(stat[index].type){
	case TYPE_SUM:
		if(i>=2)return s11;
		if(i)sprintf(s11,"Sum");
			else sprintf(s11,"Size");
		return s11;
	case TYPE_BIAS:
		if(i>=get_repertoire_size(stat[index].routine_index))return s11;
		a=get_attribute(stat[index].routine_index);
		if(a==NULL)return s11;
		if(a->type!=TYPE_REPERTOIRE)return s11;
		sprintf(s11,"%d",i);
		return s11;
	case TYPE_DISTRIBUTION:
		if(i>stat[index].max_size)return s11;
		if(!i){
			sprintf(s11,"Size");
			return s11;
		      }
		sprintf(s11,"%d",i-1);
		return s11;
	default:
		sprintf(s11,"???");
		return s11;
		
	}

}

void output_statistics(long index)
{
FIELD *f;
int i,j,k;
if(stats_out==NULL){
	if(filename==NULL)return;
	stats_out=fopen(filename,"a+");
	if(stats_out==NULL){
		fprintf(stderr,"Opening \"%s\":",filename);
		perror("");
		fflush(stderr);
		return;
		}
	/* make header */
	fprintf(stats_out,"Time,Field,");
	for(i=0;i<stat_free;i++){
		switch(stat[i].type){
			case TYPE_SUM:
				fprintf(stats_out,"%s sample size,%s,",stat[i].name,stat[i].name);
				break;
			case TYPE_BIAS:
				fprintf(stats_out,"%s,",stat[i].name);
				for(j=0;j<get_repertoire_size(stat[i].routine_index)-1;j++)fprintf(stats_out,",");
				break;
			case TYPE_DISTRIBUTION:
				fprintf(stats_out,"%s sample size,%s,",stat[i].name,stat[i].name);
				for(j=0;j<stat[i].max_size-1;j++)fprintf(stats_out,",");
				break;
			default:
				break;
			}
		}
	fprintf(stats_out,"\n");
	fflush(stats_out);
	}
f=get_field(index);
if(f==NULL)return;
compute_statistics(f);
fprintf(stats_out,"%lld,",get_time());
if(f->name!=NULL){
	fprintf(stats_out,"%s,",f->name);
	} else {
	fprintf(stats_out,",");
	}
for(i=0;i<stat_free;i++){
	k=get_number_of_values(i);
	for(j=0;j<k;j++){
		fprintf(stats_out,"%s,",get_value(i,j));
		}
	}
fprintf(stats_out,"\n");			
fflush(stats_out);
}

void output_all_statistics(void)
{
long k;

for(k=0;k<num_fields();k++){
	output_statistics(k);
	}
}	
